import mitt from "../../shared/lib/mitt";
class Span {
    end(endTime) {
        if (this.state.state === "ended") {
            throw new Error("Span has already ended");
        }
        this.state = {
            state: "ended",
            endTime: endTime != null ? endTime : Date.now()
        };
        this.onSpanEnd(this);
    }
    constructor(name, options, onSpanEnd){
        this.name = name;
        var _options_attributes;
        this.attributes = (_options_attributes = options.attributes) != null ? _options_attributes : {};
        var _options_startTime;
        this.startTime = (_options_startTime = options.startTime) != null ? _options_startTime : Date.now();
        this.onSpanEnd = onSpanEnd;
        this.state = {
            state: "inprogress"
        };
    }
}
class Tracer {
    startSpan(name, options) {
        return new Span(name, options, this.handleSpanEnd);
    }
    onSpanEnd(cb) {
        this._emitter.on("spanend", cb);
        return ()=>{
            this._emitter.off("spanend", cb);
        };
    }
    constructor(){
        this._emitter = mitt();
        this.handleSpanEnd = (span)=>{
            this._emitter.emit("spanend", span);
        };
    }
}
export default new Tracer();

//# sourceMappingURL=tracer.js.map