import 'server-only';

type RateLimitStore = Map<string, { count: number; expiresAt: number }>;

const limiters: Map<string, RateLimitStore> = new Map();

export function rateLimit(ip: string, action: string, limit: number, windowMs: number) {
  if (!limiters.has(action)) {
    limiters.set(action, new Map());
  }

  const store = limiters.get(action)!;
  const now = Date.now();
  const record = store.get(ip) || { count: 0, expiresAt: now + windowMs };

  if (now > record.expiresAt) {
    record.count = 0;
    record.expiresAt = now + windowMs;
  }

  record.count++;
  store.set(ip, record);

  // Cleanup (optional, prevents memory leak in long running process)
  if (Math.random() < 0.01) { // 1% chance to cleanup
     for (const [key, val] of store.entries()) {
        if (val.expiresAt < now) store.delete(key);
     }
  }

  return record.count <= limit;
}
