export interface Product {
  id: string;
  slug: string;
  name: string;
  price: number;
  description: string;
  image?: string;
  status: 'available' | 'coming_soon';
  paypalLink?: string;
}

export const products: Record<string, Product> = {
  "final-stand-remastered": {
    id: "p_1",
    slug: "final-stand-remastered",
    name: "Final Stand: Remastered",
    price: 9.99,
    description: "The ultimate script for your Roblox game. Features auto-farm, esp, and more.",
    image: "/fsr.png",
    status: "available",
    // Use a PayPal.me link OR a PayPal Hosted Button link (recommended for card support)
    // Create buttons at: https://www.paypal.com/buttons/
    paypalLink: "https://www.paypal.com/paypalme/finalstandremastered/9.99"
  },
  "god-mode": {
    id: "p_2",
    slug: "god-mode",
    name: "Coming Soon",
    price: 14.99,
    description: "Coming Soon",
    image: "/soon1.png",
    status: "coming_soon",
    paypalLink: "https://www.paypal.com/paypalme/finalstandremastered/14.99"
  },
  "speed-hack": {
    id: "p_3",
    slug: "speed-hack",
    name: "Coming Soon",
    price: 4.99,
    description: "Coming Soon",
    image: "/soon2.png",
    status: "coming_soon",
    paypalLink: "https://www.paypal.com/paypalme/finalstandremastered/4.99"
  }
};

export function getProduct(slug: string): Product | null {
  return products[slug] || null;
}
