import { readJSON } from '@/lib/store';

export default async function UpdatesPage() {
  const updates = await readJSON<any[]>('updates.json');

  return (
    <div className="max-w-4xl mx-auto px-4 py-12">
      <h1 className="text-3xl font-bold mb-8">Update Log</h1>
      
      <div className="relative border-l border-white/10 ml-4 space-y-12">
        {updates.map((update, i) => (
          <div key={i} className="relative pl-8">
            <div className="absolute -left-1.5 top-2 w-3 h-3 rounded-full bg-blue-500"></div>
            
            <div className="bg-white/5 border border-white/10 rounded-xl p-6">
              <div className="flex justify-between items-start mb-4">
                <h2 className="text-xl font-bold text-white">{update.version}</h2>
                <span className="text-sm text-gray-400">{update.date}</span>
              </div>
              
              <ul className="list-disc list-inside text-gray-300 space-y-2">
                {update.changes.map((change: string, j: number) => (
                  <li key={j}>{change}</li>
                ))}
              </ul>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}
