import { Youtube, Key, Terminal, Download, ShieldAlert } from 'lucide-react';
import { readJSON } from '@/lib/store';

const iconMap: any = {
  Youtube, Key, Terminal, Download, ShieldAlert
};

export default async function TutorialPage() {
  const tutorials = await readJSON<any[]>('tutorials.json');

  return (
    <div className="max-w-6xl mx-auto px-4 py-12">
      <h1 className="text-3xl font-bold mb-2">Video Tutorials</h1>
      <p className="text-gray-400 mb-10">Click on a card to watch the tutorial on YouTube.</p>
      
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        {tutorials.map((tutorial, i) => {
          const Icon = iconMap[tutorial.icon] || Youtube;
          return (
            <a 
              key={i} 
              href={tutorial.url} 
              target="_blank" 
              rel="noopener noreferrer"
              className="group bg-white/5 border border-white/10 rounded-2xl p-6 hover:bg-white/10 transition-all hover:-translate-y-1 flex items-start gap-6"
            >
              <div className={`p-4 rounded-xl bg-black/20 border border-white/5 ${tutorial.color}`}>
                <Icon size={32} />
              </div>
              <div>
                <h2 className="text-xl font-bold mb-2 flex items-center gap-2">
                  {tutorial.title}
                  <Youtube size={16} className="text-red-500 opacity-0 group-hover:opacity-100 transition-opacity" />
                </h2>
                <p className="text-gray-400 text-sm leading-relaxed">
                  {tutorial.description}
                </p>
              </div>
            </a>
          );
        })}
      </div>

      <div className="mt-12 bg-blue-500/10 border border-blue-500/20 rounded-2xl p-8 text-center">
        <h2 className="text-xl font-bold text-blue-300 mb-2">Still need help?</h2>
        <p className="text-gray-300 mb-6">
          Join our Discord server for 24/7 support and community assistance.
        </p>
        <a 
          href="https://discord.gg/Q4fsNPPnSY" 
          target="_blank" 
          rel="noopener noreferrer"
          className="inline-block bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-6 rounded-lg transition-colors"
        >
          Join Discord
        </a>
      </div>
    </div>
  );
}
