import Link from 'next/link';
import Image from 'next/image';
import { connectToDatabase } from '@/lib/db';
import { Product } from '@/lib/models';
import ProductList from './components/ProductList';

// Add revalidation to ensure store stays fresh (e.g. every 60 seconds or on demand)
export const revalidate = 0; // Dynamic for now

export default async function Home() {
  await connectToDatabase();
  const products = await Product.find({}).sort({ createdAt: 1 }).lean();

  return (
    <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
      <h1 className="text-5xl font-extrabold mb-12 text-center bg-gradient-to-r from-purple-400 via-pink-500 to-red-500 bg-clip-text text-transparent animate-pulse">
        Premium Scripts
      </h1>
      
      {products.length === 0 ? (
        <div className="text-center py-20 text-gray-500">No products available yet.</div>
      ) : (
        <ProductList products={JSON.parse(JSON.stringify(products))} />
      )}
    </div>
  );
}
