'use client';

import { motion } from 'framer-motion';
import Link from 'next/link';
import Image from 'next/image';

export default function ProductList({ products }: { products: any[] }) {
  return (
    <motion.div 
      className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"
      initial="hidden"
      animate="show"
      variants={{
        hidden: { opacity: 0 },
        show: {
          opacity: 1,
          transition: {
            staggerChildren: 0.1
          }
        }
      }}
    >
        {products.map((product: any) => (
          <motion.div
            key={product._id.toString()}
            variants={{
              hidden: { opacity: 0, y: 20 },
              show: { opacity: 1, y: 0 }
            }}
          >
          <Link
            href={product.status === 'available' ? `/product/${product.slug}` : '#'}
            className={`group block bg-white/5 border border-white/10 rounded-2xl overflow-hidden transition-all hover:bg-white/10 hover:scale-[1.02] hover:shadow-xl hover:shadow-purple-500/10 ${
              product.status !== 'available' ? 'opacity-75 cursor-not-allowed' : ''
            }`}
          >
            {product.image && (
              <div className="relative h-48 w-full mb-4 overflow-hidden">
                <Image
                  src={product.image}
                  alt={product.name}
                  fill
                  className="object-cover group-hover:scale-110 transition-transform duration-500"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
              </div>
            )}
            <div className="p-6 pt-0 relative">
            <div className="flex justify-between items-start mb-4">
              <h2 className="text-xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-white to-gray-300 group-hover:from-purple-400 group-hover:to-pink-400 transition-all duration-300">
                {product.name}
              </h2>
              <span className="bg-white/10 backdrop-blur-md text-xs px-3 py-1 rounded-full text-white font-mono border border-white/5">
                ${product.price}
              </span>
            </div>
            <p className="text-gray-400 text-sm mb-6 line-clamp-2 group-hover:text-gray-300 transition-colors">
              {product.description}
            </p>
            
            <div className="flex items-center justify-between mt-auto">
              {product.status === 'available' ? (
                <span className="text-sm font-medium text-purple-400 group-hover:translate-x-1 transition-transform flex items-center gap-2">
                  View Details 
                  <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                </span>
              ) : (
                <span className="text-xs font-bold tracking-wider text-gray-500 uppercase">
                  Coming Soon
                </span>
              )}
            </div>
            </div>
          </Link>
          </motion.div>
        ))}
    </motion.div>
  );
}
