import { NextResponse } from 'next/server';
import { connectToDatabase } from '@/lib/db';
import { Update } from '@/lib/models';
import { getSession } from '@/lib/auth';

export async function GET() {
  await connectToDatabase();
  const updates = await Update.find({}).sort({ date: -1, createdAt: -1 });
  
  const mappedUpdates = updates.map(u => ({
    ...u.toObject(),
    id: u._id.toString(),
    _id: undefined
  }));

  return NextResponse.json({ updates: mappedUpdates });
}

export async function POST(request: Request) {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  const { version, date, changes } = await request.json();
  
  await connectToDatabase();
  const newUpdate = await Update.create({
    version,
    date,
    changes: Array.isArray(changes) ? changes : [changes]
  });

  return NextResponse.json({ 
    success: true, 
    update: {
        ...newUpdate.toObject(),
        id: newUpdate._id.toString(),
        _id: undefined
    }
  });
}
