import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { ServiceRequest, ServiceChat } from '@/lib/models';

export async function POST(request: Request) {
  const session = await getSession();
  if (!session) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
  }

  const { serviceSlug, serviceTitle, details } = await request.json();

  await connectToDatabase();

  // Create the request
  const newRequest = await ServiceRequest.create({
    userId: session.user.id,
    userEmail: session.user.email,
    serviceSlug,
    serviceTitle,
    status: 'pending',
    initialDetails: details
  });

  // Add initial system message
  await ServiceChat.create({
    requestId: newRequest._id.toString(),
    senderId: 'system',
    senderRole: 'system',
    message: `Request created for ${serviceTitle}. An admin will review your details shortly.`
  });

  return NextResponse.json({ success: true, requestId: newRequest._id.toString() });
}
